theta_1 = 2 * Du * tau / delta^2;
theta_T = 2 * DT * tau / delta^2;
nu = 2 * chiT * tau * cstar / delta^2;
Dc_ag = Dc * tau / delta^2;

T = T_pde / tau;
griglia = L / delta;
griglia_uninf = cell_uninf / delta;
n_uninf = h_uninf * delta;

U = zeros(2 * griglia + 1, T_pde + 1);
Tcell = zeros(2 * griglia + 1, T_pde + 1);
c = zeros(2 * griglia + 1, T_pde + 1);
vessel = ones(2 * griglia + 1, 1);

% Inizializzazione cellule non infette
U(:, 1) = [zeros(griglia - griglia_uninf, 1);
           n_uninf * ones(2 * griglia_uninf + 1, 1);
           zeros(griglia - griglia_uninf, 1)];

U_temp = U(:, 1);
Tc_temp = Tcell(:, 1);
c_temp = c(:, 1);

for i = 2:T + 1
    P = U_temp;  % Pressione basata solo sulle U

    % Diffusione cellule U e T con chemotassi
    U_temp = passeggiata_unod_smorzata(U_temp, theta_1);
    Tc_temp = passeggiata_unod_chemotaxisdiffusion(Tc_temp, c_temp, theta_T, nu, cstar);

    % Nascita/morte per pressione
    U_temp = nascitamorte_pressione(U_temp, P, K * delta, p * tau, 0);
    Tc_temp = nascitamorte_pressione(Tc_temp, P, K * delta, 0, qT * tau);

    % Inflow cellule T
    Tc_temp = inflow(Tc_temp, alphaz * sum(U_temp) * delta * tau, vessel);

    % Uccisione da parte del sistema immunitario
    U_temp = T_kill(U_temp, Tc_temp, min(1, zU * tau / delta));

    % Dinamica della sostanza chimica
    c_temp = dinamicac_unod(c_temp, Dc_ag, zeros(size(U_temp)), alphac * tau / delta, ...
                             U_temp, gammac * tau / delta, cstar, qc * tau);

    % Controllo NaN
    if any(isnan(U_temp)) || any(isnan(Tc_temp))
        i
    end

    % Salvataggio delle variabili ogni ora intera
    t = (i - 1) * tau;
    if t == floor(t)
        U(:, t + 1) = U_temp;
        Tcell(:, t + 1) = Tc_temp;
        c(:, t + 1) = c_temp;

        figure(1)
        clf
        subplot(1, 2, 1)
        plot(U_temp / delta)
        title("Cellule non infette")

        subplot(1, 2, 2)
        plot(Tc_temp / delta)
        title("Cellule T")
    end
end
% Cosa è stato rimosso:
% (1) variabili I, griglia_inf, n_inf
% (2) tutti i riferimenti a infezione_dued, T_kill su infette, beta
% (3) la diffusione e aggiornamento di cellule infette
% (4) le funzioni che coinvolgevano I (in dinamicac_unod, abbiamo passato uno zeros(...) per I)
% (5) plot relativi a I